<?php
/**
 * Accept Terms
 * Require users to accept a terms of service before posting in specific forums.
 *
 * @author: Spencer Swords
 * @file: accept_terms.php
 */
 
// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("newthread_start", "accept_terms_thread");
$plugins->add_hook("newreply_start", "accept_terms_thread");
$plugins->add_hook("showthread_end", "accept_terms_quickreply");
$plugins->add_hook("index_start", "accept_terms_agreement");

function accept_terms_info()
{
	return array(
		"name"			=> "هاك الموافقه علي شروط القسم",
		"description"	=> "يجب علي العضو قراءة الشروط التي قمت بوضعها قبل انشاء موضوع او الرد.",
		"website"		=> "",
		"author"		=> "Spencer Swords",
		"authorsite"	=> "http://community.mybb.com/user-23387.html",
		"version"		=> "1.0",
		"guid" 			=> "01700d2ca6302aa8634eb6482ec01c7e",
		"compatibility" => "*"
	);
}

function accept_terms_install()
{
	global $db;
	
	$group = array (
		"name"			=> "accept_terms",
		"title"			=> "هاك الموافقه علي شروط القسم",
		"description"	=> "اعدادات الهاك.",
		"disporder"		=>	100,
		"isdefault"		=>	0
	);
	$gid = $db->insert_query("settinggroups", $group);
	
	$settings[] = array (
		"sid"			=> NULL,
		"name"			=> "tos_enable",
		"title"			=> "تفعيل  / ايقاف",
		"description"	=> "تستطيع ايقاف او تشغيل الهاك من هنا",
		"optionscode"	=> "yesno",
		"value"			=> 1,
		"disporder"		=> 1,
		"gid"			=> $gid			
	);
	
	$settings[] = array (
		"sid"			=> NULL,
		"name"			=> "tos_message",
		"title"			=> "الرسالة.",
		"description"	=> "ضع الرسالة المراد ظهورها للعضو.",
		"optionscode"	=> "textarea",
		"value"			=> "",
		"disporder"		=> 2,
		"gid"			=> $gid			
	);
	
	$settings[] = array (
		"sid"			=> NULL,
		"name"			=> "tos_forums",
		"title"			=> "الاقسام.",
		"description"	=> "ضع ايدي الاقسام المراد تفعيل الهاك به ويجب علي العضو الموافقه علي الشروط بها قبل انشاء الموضوع او الرد.",
		"optionscode"	=> "text",
		"value"			=> "",
		"disporder"		=> 4,
		"gid"			=> $gid			
	);
	
	foreach($settings as $setting)
	{
		$db->insert_query("settings", $setting);
	}
	
	rebuild_settings();
	
	$db->write_query("
		CREATE TABLE `".TABLE_PREFIX."accept_terms` (
			id int(10) NOT NULL auto_increment,
			fid smallint(5) NOT NULL,
			uid int(10) NOT NULL,
			dateline bigint(30) NOT NULL,
			verified smallint(1) NOT NULL,
			`key` varchar(10) NOT NULL DEFAULT '',
			PRIMARY KEY (id)
		) ENGINE=MyISAM ;
	");	
}

function accept_terms_is_installed()
{
	global $db;
	
	if($db->table_exists("accept_terms"))
	{
		return true;
	}
	else
	{
		false;
	}
}

function accept_terms_uninstall()
{
	global $db, $mybb;
	
	$db->delete_query("settinggroups", "name = 'accept_terms'");
	$db->delete_query('settings', 'name IN (\'tos_enable\',\'tos_message\',\'tos_forums\')');
	
	rebuild_settings();

	if($db->table_exists("accept_terms"))
	{
		$db->drop_table("accept_terms");
	}
}

function accept_terms_quickreply()
{
	global $db, $mybb, $quickreply;
	
	if($mybb->settings['tos_enable'] == 1)
	{
		if(!$mybb->input['fid'])
		{
			$tid = $mybb->input['tid'];
			$query = $db->simple_select("threads", "*", "tid='".$tid."'");
			if($db->num_rows($query) == 0)
			{
				error($lang->error_invalidthread);
			}
			$thread = $db->fetch_array($query);
			$fid = $thread['fid'];
		}
		else
		{
			$fid = $mybb->input['fid'];
		}
		
		// check if forum requires term acceptance...
		$fids = explode(",", $mybb->settings['tos_forums']);
		if(in_array($fid, $fids))
		{	
			// check if user has accepted tos
			$query = $db->simple_select("accept_terms", "*", "uid = '{$mybb->user['uid']}' AND fid = '{$fid}' AND verified = '1'");
			$num_rows = $db->num_rows($query);

			if($num_rows == 0)
			{
				$quickreply = "";
			}
		}
	}	
}

function accept_terms_thread()
{
	global $db, $mybb, $lang;
	
	$lang->load("accept_terms");
	
	if($mybb->settings['tos_enable'] == 1)
	{
		if(!$mybb->input['fid'])
		{
			$tid = $mybb->input['tid'];
			$query = $db->simple_select("threads", "*", "tid='".$tid."'");
			if($db->num_rows($query) == 0)
			{
				error($lang->error_invalidthread);
			}
			$thread = $db->fetch_array($query);
			$fid = $thread['fid'];
		}
		else
		{
			$fid = $mybb->input['fid'];
		}
		
		// check if forum requires term acceptance...
		$fids = explode(",", $mybb->settings['tos_forums']);
		if(in_array($fid, $fids))
		{		
			// check if user has accepted tos
			$query = $db->simple_select("accept_terms", "*", "uid = '{$mybb->user['uid']}' AND fid = '{$fid}' AND verified = '1'");
			$num_rows = $db->num_rows($query);
			
			if($num_rows == 0)
			{		
				// generate key; insert into database
				$key = random_str(10);
				
				// check if there is already a pending verification for this user...
				$query = $db->simple_select("accept_terms", "*", "uid = '{$mybb->user['uid']}' AND fid = '{$fid}' AND verified = '0'");
				$num_rows = $db->num_rows($query);

				if($num_rows <= 0)
				{	
					$insert = array(
						"fid" => $fid,
						"uid" => $mybb->user['uid'],
						"dateline" => TIME_NOW,
						"verified" => 0,
						"key" => $key
					);
					$db->insert_query("accept_terms", $insert);
				
					// send private message
					$pm = array(
						"subject" => $lang->pm_subject,
						"message" => "Hello,
						
Our records indicate you have requested access to reply to and create new threads in our forum which we require all users to review and agree to our terms. 
Please read over our terms outlined below. Once you have read and agreed to them, click the link to process your request.
						
[quote]".$mybb->settings['tos_message']."[/quote]
						
[url=".$mybb->settings['bburl']."/index.php?action=agree&key={$key}]Click here to process your agreement[/url]
						
This is an automated message. Do not reply.",
						"touid" => intval($mybb->user['uid']),
						"receivepms" => 1,
					);
					accept_terms_send_pm($pm, 1);
					
					error($lang->tos_error, $lang->tos_error_title);
				}
				else
				{
					error($lang->tos_error_exist, $lang->tos_error_title);
				}
			}
		}
	}
}

function accept_terms_agreement()
{
	global $db, $mybb, $lang;
	
	$lang->load("accept_terms");
	
	if($mybb->input['action'] == "agree" && $mybb->input['key'] != "")
	{
		// check if key is valid
		$query = $db->simple_select("accept_terms", "*", "verified='0' AND `key`='{$mybb->input['key']}' AND uid='{$mybb->user['uid']}'");
		$num = $db->num_rows($query);
		
		if($num > 0)
		{
			$update = array(
				"verified" => 1
			);
			$db->update_query("accept_terms", $update, "uid='{$mybb->user['uid']}'");
			
			error($lang->terms_success_msg, $lang->terms_title);
		}
		else
		{
			error($lang->terms_error_msg, $lang->terms_title);
		}
	}
}

function accept_terms_send_pm($pm, $fromid = 0)
{
    global $lang, $mybb, $db;
	
	if($mybb->settings['enablepms'] == 0)
	{
		return false;
	}
	if(!is_array($pm))
	{
		return false;
	}
	if(!$pm['subject'] || !$pm['message'] || !$pm['touid'] || !$pm['receivepms'])
	{
		return false;
	}
	
	$lang->load("messages");
    
	require_once MYBB_ROOT."inc/datahandlers/pm.php";
    $pmhandler = new PMDataHandler();
    
    $subject = $pm['subject'];
    $message = $pm['message'];
    $toid = $pm['touid'];
    
    if (is_array($toid))
	{
        $recipients_to = $toid;
	}
    else
	{
        $recipients_to = array($toid);
	}
	
    $recipients_bcc = array();
    
    if (intval($fromid) == 0)
	{
        $fromid = intval($mybb->user['uid']);
	}
    elseif (intval($fromid) < 0)
	{
        $fromid = 0;
	}

    $pm = array(
        "subject" => $subject,
        "message" => $message,
        "icon" => -1,
        "fromid" => $fromid,
        "toid" => $recipients_to,
        "bccid" => $recipients_bcc,
        "do" => '',
        "pmid" => ''
    );

    $pm['options'] = array(
        "signature" => 0,
        "disablesmilies" => 0,
        "savecopy" => 0,
        "readreceipt" => 0
    );
    $pm['saveasdraft'] = 0;
    $pmhandler->admin_override = 1;
    $pmhandler->set_data($pm);
    if($pmhandler->validate_pm())
    {
        $pmhandler->insert_pm();
	}
    else
    {
        return false;
	}
    
    return true;
} 
?>